Minutes from 17th OpenVDB TSC meeting, May 23, 2019

Attendees: *Nick* A., *Dan* B., *Peter* C., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel), John Mertic (LF)

Regrets: *Ken* M.

Agenda:

1) Quorum Confirmation
2) Secretary Selection
3) CI Update (Dan)
4) CLA Update (John)
5) Mainline Remote Branches (Nick)
6) Switch to Relative Header Paths (Peter)
7) OpHiding Next Steps (Dan)
8) GitHub Issues Cleanup / Process for Submitting Bug Reports (Nick/Jeff)
9) VDB Delayed Loading (Dan)
10) Maya Plugin (Nick)
11) Level Target Pruning/Voxelization (Nick)
12) Speed of hasActiveTiles/voxelizeActiveTiles (Nick)
13) Schedule Next Meeting

1) A quorum was confirmed

2) Secretary - Nick Avramoussis

3) CI Update

The ASWF is moving towards Azure Pipelines. We will again have to migrate over
our CircleCI implementation. Tests using docker have already been put together
and show promising results. We'll most likely support both Circle and Azure
during Azure adoption, then deprecate and remove Circle.

4) CLA Update

Up until now there has been no automatic process whilst we've been waiting for
the LF automated CLA system. This new system can be triggered through first
commits or pull requests to the repository. The DCO will still be required -
there are a bunch of command line signoff tools to help with this, John has
compiled a list here:

https://github.com/jmertic/dco-org-check#useful-tools-to-make-doing-dco-signoffs-easier

TSC members should look to sign the digital CLA as a CLA manager and get signoff
from a CLA Signatory from within their organization. Consensus from the TSC was
to wait for all 5 TSC members to have gone through the new digital CLA process
before enabling it on the OpenVDB repository.

5) Mainline Remote Branches

A brief comment about keeping the repository clear of remote branches. Nick to
remove the last remote created by Ken and to close off that work. Informal
agreement to keep the main repository clear of remote branches bar release
branches.

6) Switch to Relative Header Paths

OpenVDB currently uses absolutely header paths to pull in other OpenVDB headers.
This may be an issue if you already have an installed version of OpenVDB on your
system, those headers could be pulled in during compilation. This was true with
the old Make system but may not be an issue anymore with how the CMake is set-up.
There are three avenues to explore here - changing the Core library to use
relative headers to itself, the plugins to use relative headers to themselves
and finally the plugins to use relative header paths to the core library. The
latter will impact Jeffs/SESIs Houdini integration. Peter to do the bare minimum
update. Nick to investigate if this is still an issue with CMake.

7) OpHiding Next Steps

A idea to expand the Houdini menu system via xml/python to provide options to
disable/enable OpenVDB Nodes could potentially help users switch between
SESI/ASWF nodes interactively, though is orthogonal to the issue of site set-up.
The SESI nodes have different opnames to the ASWF ones which complicates
generating an opcustomize file - though the current way around this is hard
coding them in the AWSF SOPs so this could potentially be duplicated. The SOPs
themselves could also be used to generate the opcustomize script. Dan to
investigate command line tooling during or post compilation to achieve this.

8) GitHub Issues Cleanup / Process for Submitting Bug Reports

Forums vs github Issues. At first glance the forum seems to be mainly for
discussion where as github issues are being used far more for bug reporting.
github issues can only be open or closed - there is no intermediate state such
as 'Stalled' or 'Awaiting Response' which makes them harder to use for
communicating with users and tracking status. We have set no expectations for
users who are reporting bugs/issues/questions. It was generally agreed to
continue monitoring the forums and github issues, creating tickets in Jira from
verified posts and closing out github issues which have received no update in
over a week. Nick to write up a proposal for this which, once agreed, can also
be posted/pinned to the forum.

9) VDB Delayed Loading

Currently uses OpenVDB's metadata system to track the enabling/disabling of
the improved delay loading implementation. A more ideal solution would be to
expose a hook in the file io code, but this will take time to filter down due
to ABI/file format compatibility. We don't really want two APIs achieving the
same result, it would be good if an attempt at implementing a hook in the file
io could be proposed to achieve later forwards compatibility. It was decided
that the metadata should at least be cleaned-up on read so it is in no way
exposed to the user. We should also investigate warning/skipping on internally
known types and ensure the metadata name is prefixed with "__".

10) Maya Plugin

There are issues with the Maya plugin, specifically the OpenVDB Visualize node,
in Maya's view-port 2. We should create tickets to get Maya into CI and at a
minimum produce documentation explaining how to enable the OpenVDB Visualize
node in Maya 2018/2019.

11) Level Target Pruning/Voxelization (Nick)

Using VDB topology for load balancing operations which are sensitive to the
node size used i.e. voxel, tile, internal node. Nick to send around a
proposal for what this implementation could look like and the desired
functionality.

12) Speed of hasActiveTiles/voxelizeActiveTiles (Nick)

Time.

13) Schedule Next Meeting

May 30th 2019.  3pm-4pm EDT (GMT-4).
