#ifndef PERF_UTIL_BPF_SKEL_SAMPLE_FILTER_H
#define PERF_UTIL_BPF_SKEL_SAMPLE_FILTER_H

#define MAX_FILTERS   64
#define MAX_IDX_HASH  (16 * 1024)
#define MAX_EVT_HASH  (1024 * 1024)

/* supported filter operations */
enum perf_bpf_filter_op {
	PBF_OP_EQ,
	PBF_OP_NEQ,
	PBF_OP_GT,
	PBF_OP_GE,
	PBF_OP_LT,
	PBF_OP_LE,
	PBF_OP_AND,
	PBF_OP_GROUP_BEGIN,
	PBF_OP_GROUP_END,
	PBF_OP_DONE,
};

enum perf_bpf_filter_term {
	/* No term is in use. */
	PBF_TERM_NONE = 0,
	/* Terms that correspond to PERF_SAMPLE_xx values. */
	PBF_TERM_SAMPLE_START	= PBF_TERM_NONE + 1,
	PBF_TERM_IP		= PBF_TERM_SAMPLE_START + 0, /* SAMPLE_IP = 1U << 0 */
	PBF_TERM_TID		= PBF_TERM_SAMPLE_START + 1, /* SAMPLE_TID = 1U << 1 */
	PBF_TERM_TIME		= PBF_TERM_SAMPLE_START + 2, /* SAMPLE_TIME = 1U << 2 */
	PBF_TERM_ADDR		= PBF_TERM_SAMPLE_START + 3, /* SAMPLE_ADDR = 1U << 3 */
	__PBF_UNUSED_TERM4	= PBF_TERM_SAMPLE_START + 4, /* SAMPLE_READ = 1U << 4 */
	__PBF_UNUSED_TERM5	= PBF_TERM_SAMPLE_START + 5, /* SAMPLE_CALLCHAIN = 1U << 5 */
	PBF_TERM_ID		= PBF_TERM_SAMPLE_START + 6, /* SAMPLE_ID = 1U << 6 */
	PBF_TERM_CPU		= PBF_TERM_SAMPLE_START + 7, /* SAMPLE_CPU = 1U << 7 */
	PBF_TERM_PERIOD		= PBF_TERM_SAMPLE_START + 8, /* SAMPLE_PERIOD = 1U << 8 */
	__PBF_UNUSED_TERM9	= PBF_TERM_SAMPLE_START + 9, /* SAMPLE_STREAM_ID = 1U << 9 */
	__PBF_UNUSED_TERM10	= PBF_TERM_SAMPLE_START + 10, /* SAMPLE_RAW = 1U << 10 */
	__PBF_UNUSED_TERM11	= PBF_TERM_SAMPLE_START + 11, /* SAMPLE_BRANCH_STACK = 1U << 11 */
	__PBF_UNUSED_TERM12	= PBF_TERM_SAMPLE_START + 12, /* SAMPLE_REGS_USER = 1U << 12 */
	__PBF_UNUSED_TERM13	= PBF_TERM_SAMPLE_START + 13, /* SAMPLE_STACK_USER = 1U << 13 */
	PBF_TERM_WEIGHT		= PBF_TERM_SAMPLE_START + 14, /* SAMPLE_WEIGHT = 1U << 14 */
	PBF_TERM_DATA_SRC	= PBF_TERM_SAMPLE_START + 15, /* SAMPLE_DATA_SRC = 1U << 15 */
	__PBF_UNUSED_TERM16	= PBF_TERM_SAMPLE_START + 16, /* SAMPLE_IDENTIFIER = 1U << 16 */
	PBF_TERM_TRANSACTION	= PBF_TERM_SAMPLE_START + 17, /* SAMPLE_TRANSACTION = 1U << 17 */
	__PBF_UNUSED_TERM18	= PBF_TERM_SAMPLE_START + 18, /* SAMPLE_REGS_INTR = 1U << 18 */
	PBF_TERM_PHYS_ADDR	= PBF_TERM_SAMPLE_START + 19, /* SAMPLE_PHYS_ADDR = 1U << 19 */
	__PBF_UNUSED_TERM20	= PBF_TERM_SAMPLE_START + 20, /* SAMPLE_AUX = 1U << 20 */
	PBF_TERM_CGROUP		= PBF_TERM_SAMPLE_START + 21, /* SAMPLE_CGROUP = 1U << 21 */
	PBF_TERM_DATA_PAGE_SIZE	= PBF_TERM_SAMPLE_START + 22, /* SAMPLE_DATA_PAGE_SIZE = 1U << 22 */
	PBF_TERM_CODE_PAGE_SIZE	= PBF_TERM_SAMPLE_START + 23, /* SAMPLE_CODE_PAGE_SIZE = 1U << 23 */
	PBF_TERM_WEIGHT_STRUCT	= PBF_TERM_SAMPLE_START + 24, /* SAMPLE_WEIGHT_STRUCT = 1U << 24 */
	PBF_TERM_SAMPLE_END	= PBF_TERM_WEIGHT_STRUCT,
	/* Terms computed from BPF helpers. */
	PBF_TERM_UID,
	PBF_TERM_GID,
};

/* BPF map entry for filtering */
struct perf_bpf_filter_entry {
	enum perf_bpf_filter_op op;
	__u32 part; /* sub-sample type info when it has multiple values */
	enum perf_bpf_filter_term term;
	__u64 value;
};

struct idx_hash_key {
	__u64 evt_id;
	__u32 tgid;
	__u32 reserved;
};

#endif /* PERF_UTIL_BPF_SKEL_SAMPLE_FILTER_H */
