; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=amdgcn-amd-amdhsa -S -amdgpu-aa-wrapper -amdgpu-aa -instcombine -o - %s | FileCheck %s
;
; Test AA::pointsToConstantMemory implementation. These should mostly
; turn out to be stores to constant memory, and will therefore be
; deleted as UB.

define void @test_constant_addrspace(i8 addrspace(4)* %p) {
; CHECK-LABEL: @test_constant_addrspace(
; CHECK-NEXT:    ret void
;
  store i8 0, i8 addrspace(4)* %p
  ret void
}

define void @test_constant32bit_addrspace(i8 addrspace(6)* %p) {
; CHECK-LABEL: @test_constant32bit_addrspace(
; CHECK-NEXT:    ret void
;
  store i8 0, i8 addrspace(6)* %p
  ret void
}

define void @test_cast_generic_from_constant_addrspace(i8 addrspace(4)* %p) {
; CHECK-LABEL: @test_cast_generic_from_constant_addrspace(
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast i8 addrspace(4)* %p to i8*
  store i8 0, i8* %cast
  ret void
}

define void @test_cast_generic_from_constant32bit_addrspace(i8 addrspace(6)* %p) {
; CHECK-LABEL: @test_cast_generic_from_constant32bit_addrspace(
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast i8 addrspace(6)* %p to i8*
  store i8 0, i8* %cast
  ret void
}

define void @test_cast_generic_to_constant_addrspace(i8* %p) {
; CHECK-LABEL: @test_cast_generic_to_constant_addrspace(
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast i8* %p to i8 addrspace(4)*
  store i8 0, i8 addrspace(4)* %cast
  ret void
}

define void @test_cast_generic_to_constant32bit_addrspace(i8* %p) {
; CHECK-LABEL: @test_cast_generic_to_constant32bit_addrspace(
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast i8* %p to i8 addrspace(6)*
  store i8 0, i8 addrspace(6)* %cast
  ret void
}

define amdgpu_kernel void @noalias_readnone_global_kernarg(i32 addrspace(1)* noalias readnone %arg) {
; CHECK-LABEL: @noalias_readnone_global_kernarg(
; CHECK-NEXT:    ret void
;
  store i32 0, i32 addrspace(1)* %arg
  ret void
}

define amdgpu_kernel void @noalias_readonly_global_kernarg(i32 addrspace(1)* noalias readonly %arg) {
; CHECK-LABEL: @noalias_readonly_global_kernarg(
; CHECK-NEXT:    ret void
;
  store i32 0, i32 addrspace(1)* %arg
  ret void
}

define amdgpu_kernel void @readnone_global_kernarg(i32 addrspace(1)* readnone %arg) {
; CHECK-LABEL: @readnone_global_kernarg(
; CHECK-NEXT:    store i32 0, i32 addrspace(1)* [[ARG:%.*]], align 4
; CHECK-NEXT:    ret void
;
  store i32 0, i32 addrspace(1)* %arg
  ret void
}

define amdgpu_kernel void @readonly_global_kernarg(i32 addrspace(1)* readonly %arg) {
; CHECK-LABEL: @readonly_global_kernarg(
; CHECK-NEXT:    store i32 0, i32 addrspace(1)* [[ARG:%.*]], align 4
; CHECK-NEXT:    ret void
;
  store i32 0, i32 addrspace(1)* %arg
  ret void
}

@global_as_constant = external addrspace(1) constant i32, align 4

define amdgpu_kernel void @constant_gv_global_as() {
; CHECK-LABEL: @constant_gv_global_as(
; CHECK-NEXT:    ret void
;
  store i32 0, i32 addrspace(1)* @global_as_constant
  ret void
}

@global_nonconstant_constant_as = external addrspace(4) global i32, align 4

define amdgpu_kernel void @nonconst_gv_constant_as() {
; CHECK-LABEL: @nonconst_gv_constant_as(
; CHECK-NEXT:    ret void
;
  store i32 0, i32 addrspace(4)* @global_nonconstant_constant_as
  ret void
}
