/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
//
// C++ Implementation: nobox2pml
//
// Description: 
// WARNING: this is NOT a direct .noboite to PML translator !!!
// the first argument is the name of a file (the nobox file) that you will have to arrange manually from the noboite.
// The nobox format is as follow :
// - nr of vertices (as given by the ghs3d command output) on the first line
// - list of all coordinates (cut & paste the end part of the noboite to the beginning)
// - nr of tetrahedra (as given by the ghs3d command output)
// - and finally then the list of tetrahedra (the first part of the noboite file without the first garbage looking line)

// here is an example of a nobox file:
// 201
//   212.949997  210.878006  49.9991989  211.138  218.839005  49.9991989
//   211.072998  214.925003  56.9520988  211.063995  206.959  56.9835014
//   211.104004  202.927002  49.9990997  211.065002  206.959  43.0144997
//   211.074005  214.925995  43.0461998  205.429993  226.548996  49.9990997
//   205.117996  224.679001  57.9211998  205.076996  218.942993  63.7588005
//   204.927002  211.143997  65.9347992  204.996002  203.227005  63.8834991
//   204.904999  197.218994  58.0499001  205.156998  195.229996  49.9992981
//   204.904007  197.218002  41.9476013  204.994003  203.225998  36.1137009
//   204.925995  211.143997  34.0623016  205.076996  218.942993  36.2391014
//   205.117996  224.679993  42.0769997  195.733994  233.279999  49.9991989
//   195.425995  231.682007  58.651001  195.128006  227.037003  65.908699
//   194.822998  219.987  70.8787994  194.681  211.408997  72.7072983  194.744995
//   202.714005  70.9886017  194.737  195.322006  66.1066971  194.841003
//   190.419006  58.8510017  194.957001  188.701004  49.9998016  194.837997
//   190.419006  41.1478004  194.733002  195.320999  33.8917999  194.740005
//   202.712997  29.0091991  194.677994  211.406998  27.2901993  194.820999
//   219.985992  29.1184006  195.126999  227.037003  34.0895996  195.425995
//   231.682007  41.3474007  182.660004  238.115997  49.9992981  182.451996
//   236.664993  58.9043999  182.085007  232.565994  66.7394028  181.636993
//   226.253998  72.8107986  181.039993  218.354004  76.5053024  180.806
//   209.505997  77.3675003  181.317993  200.705994  75.1343002  181.591995
//   193.024002  70.060997  181.746994  187.490005  62.9435005  181.738007
//   184.610001  54.4679985  181.735992  184.610001  45.5321999  181.742004
//   187.490005  37.0563011  181.585007  193.024002  29.9388008  181.311996
//   200.703003  24.8658009  180.802994  209.505005  22.6319008  181.039001
//   218.352005  23.4941006  181.636002  226.253006  27.1879997  182.084
//   232.565002  33.2593994  182.451004  236.664993  41.0942001  167.472
//   240.304993  49.9994011  167.315994  238.871994  59.1222  166.912003
//   234.809998  67.2751999  166.324997  228.537994  73.7573013  165.412003
//   220.673004  77.9524994  163.651001  212.367996  79.447998  165.856003
//   202.725006  77.8918991  166.429993  194.429001  73.637001  166.608002
//   187.936996  67.093399  166.662003  183.886993  59.0017014  166.753998
//   182.429001  50.0009003  166.658997  183.886993  41.0004005  166.602005
//   187.936996  32.908699  166.423004  194.427994  26.3642006  165.848999
//   202.725006  22.1098995  163.647995  212.365997  20.5538998  165.410995
//   220.671005  22.0482006  166.324005  228.537003  26.2420998  166.910995
//   234.809006  32.7238998  167.315994  238.871994  40.8764  151.835999
//   239.468002  49.9996986  151.660004  237.951004  59.1351013  151.274002
//   233.610992  67.2938004  150.830002  226.940994  73.6313019  150.115997
//   218.690994  77.3936005  149.949997  209.399002  78.143898  150.544998
//   200.186996  75.7360992  150.968002  192.516006  70.6867981  151.110992
//   186.903  63.3594017  151.274994  183.906998  54.6599998  151.274002
//   183.906998  45.3432999  151.106995  186.903  36.6436005  150.962006
//   192.516006  29.3166008  150.539001  200.188004  24.2667007  149.944
//   209.399994  21.8596992  150.113007  218.690994  22.6088009  150.828003
//   226.940002  26.3701  151.272003  233.610992  32.7069016  151.660004
//   237.951004  40.8646011  137.266006  235.638  50.0005989  137.052002
//   233.746994  59.2244987  136.727997  228.546005  67.0988007  136.380997
//   220.755997  72.3856964  136.190002  211.565002  74.2394028  136.380997
//   202.220993  72.3259964  136.684998  194.445007  67.0942993  136.906998
//   189.218994  59.2350998  137.018005  187.365005  50.0015984  136.906006
//   189.220001  40.767601  136.682007  194.447006  32.9085007  136.378006
//   202.223007  27.6765995  136.186005  211.567001  25.7646008  136.378998
//   220.757996  27.6180992  136.727005  228.546997  32.9045982  137.052002
//   233.748001  40.7779999  125.139  229.164001  50.0024986  124.925003
//   226.662003  58.8370018  124.797997  220.257996  65.3336029  124.700996
//   211.386993  67.7137985  124.739998  202.552994  65.2739029  124.971001
//   196.110001  58.8339996  125.170998  193.675995  50.0007019  124.971001
//   196.112  41.167099  124.737999  202.557007  34.7289009  124.698997
//   211.391006  32.2905998  124.796997  220.261993  34.6725006  124.926003
//   226.664001  41.1697998  116.166  220.483002  50.0068016  116.230003
//   215.843994  58.0330009  116.362  206.574005  58.0284996  116.43  201.942001
//   49.9977989  116.365997  206.580994  41.9715004  116.234001  215.852005
//   41.9760017  114.734001  210.878006  49.9991989  174.122116  217.068161
//   31.7504559  172.845322  217.308792  48.5277519  167.153168  214.523697
//   39.7758484  181.559479  210.526749  34.7726517  188.018204  215.87796
//   39.7380791  184.143738  224.294205  42.0575256  197.055756  214.458328
//   38.7829208  194.991425  210.800476  54.7543221  193.28717  202.241409
//   40.9057541  204.158218  205.777817  50.9520607  197.350235  221.431885
//   46.0859756  205.353348  213.013306  46.1315346  136.512878  212.353867
//   63.7603073  136.803589  212.550674  48.2269096  137.144806  220.346344
//   61.4673576  145.934494  210.935974  55.5667152  147.122406  219.049301
//   65.7673264  127.637863  213.684891  57.7648048  155.055756  219.283691
//   57.2817078  157.627609  218.691803  68.3738556  158.877777  227.444443
//   60.4090767  157.239014  214.618912  42.7295799  150.678391  224.44072
//   42.8708191  156.86319  228.042023  52.577179  167.16449  229.505142
//   47.8503952  166.877808  224.886551  59.4400215  167.344315  209.241409
//   57.7920151  156.016373  211.103333  65.0439377  125.501251  217.264023
//   49.4178391  144.429642  209.962738  39.080452  130.778366  213.858948
//   40.0691223  140.463333  222.008209  39.4355965  139.815598  225.72168
//   49.4672127  136.28949  202.349487  41.0455284  145.962448  195.281769
//   48.8271103  147.488693  198.23613  37.7950897  136.704361  200.614502
//   59.242939  150.481583  199.411041  60.4735184  152.468857  198.37587
//   45.7318878  157.677902  191.62085  51.4769325  196.616882  218.971909
//   57.1982651  204.238693  213.30249  54.1141624  159.744888  232.552795
//   43.8564072  168.660782  225.179016  37.9129562  191.862534  205.648514
//   62.5157318  180.80452  209.505508  49.9997406  183.883865  197.143555
//   56.6907158  145.60112  228.086609  57.396431  175.108383  231.910431
//   53.4562454  175.68959  225.918808  59.6542206  185.944397  224.478149
//   56.2026367  174.792694  192.130005  49.9737282  174.053543  196.442856
//   37.7757225  182.502289  197.298569  48.2248764  166.223877  195.831894
//   42.2486687  173.008575  202.979706  46.7984734  166.829437  195.548477
//   57.1409531  157.996948  207.388916  32.52491  171.89621  216.18663
//   67.2036209  173.671951  200.933304  66.221962  180.062073  210.119934
//   64.1635513  187.354813  211.602554  65.3569107  194.980927  199.277191
//   52.4201088  123.912224  207.559799  50.1583328  158.063065  201.043579
//   66.0226746  157.567657  206.597137  51.0658493  183.447632  200.285034
//   38.0877419  169.998138  205.641113  32.1545448  136.224457  199.33667
//   50.2796478  159.975189  221.28949  31.02672  144.484528  214.412399
//   33.054985  146.594879  207.633087  66.7936783  158.706665  193.814636
//   36.3628883
// 764
//  129 130 131 132 133 129 130 134 129 133 132 51 135 133 32 31 135 136 137 138
//  135 136 139 133 135 18 139 140 135 138 137 16 135 16 137 31 141 142 143 144 141
//  98 145 97 141 146 112 143 147 148 149 145 147 150 144 151 130 147 152 150 150
//  130 153 152 154 147 152 130 147 155 130 154 156 154 155 147 141 143 142 146 142
//  146 143 157 142 158 159 160 142 160 157 161 162 163 164 158 163 144 165 166 166
//  163 101 165 85 86 103 163 163 144 166 167 83 163 101 166 84 163 168 85 163 168
//  167 166 84 163 83 168 163 83 168 166 169 8 170 140 171 172 151 92 171 172 92 73
//  136 173 174 175 171 172 73 74 171 55 152 153 171 153 74 55 176 145 77 96 143
//  144 147 145 161 144 147 143 147 143 176 161 161 152 75 176 176 161 94 75 176 76
//  152 75 147 176 145 149 149 76 57 56 149 145 148 78 147 152 149 154 149 154 56
//  57 149 78 148 58 149 58 154 57 177 153 74 54 177 178 57 154 177 153 54 134 177
//  134 130 153 178 177 37 179 177 153 56 55 130 154 178 177 180 181 182 47 180 181
//  183 184 180 64 185 65 180 65 183 66 180 182 45 46 180 184 183 185 168 185 65
//  183 131 183 150 186 187 61 188 41 187 178 58 39 178 187 189 39 187 40 60 41 178
//  189 179 39 187 188 189 41 190 25 173 24 24 173 136 11 136 179 174 190 169 190
//  23 179 190 40 189 41 133 134 34 52 179 190 23 39 40 39 190 189 13 191 12 138
//  192 159 162 118 142 192 165 146 187 156 155 193 136 12 170 11 136 138 191 137
//  179 174 190 189 136 179 133 174 136 169 11 170 136 190 174 173 136 137 174 133
//  130 131 132 184 129 172 130 134 172 130 150 131 131 130 150 184 130 150 184 194
//  49 195 31 132 130 189 155 174 189 155 187 130 196 181 49 195 196 49 181 68 129
//  131 196 132 192 159 118 126 142 165 192 197 196 186 131 70 196 50 132 49 186
//  198 70 90 167 150 144 194 150 199 198 186 151 150 199 198 186 90 199 198 186 88
//  199 89 186 150 199 158 194 130 147 155 158 186 150 167 150 131 198 172 150 199
//  158 151 147 150 194 144 200 98 99 80 129 196 50 132 129 172 72 198 192 197 115
//  116 129 132 50 51 196 186 183 131 131 184 150 183 186 201 68 196 196 186 69 68
//  186 150 131 198 130 174 132 133 88 201 68 186 194 155 156 166 150 194 130 147
//  147 194 155 156 158 167 150 144 130 174 155 184 135 136 138 140 147 194 156 144
//  155 174 175 184 130 155 187 154 161 110 94 109 194 184 185 183 142 151 161 144
//  142 197 162 144 162 144 158 142 28 27 175 45 144 197 162 163 193 156 80 60 187
//  193 155 188 193 82 166 83 155 193 185 188 80 193 200 156 178 179 38 39 193 156
//  166 200 135 140 16 17 144 145 200 156 176 95 143 96 145 143 97 96 145 79 156
//  148 147 176 149 152 196 183 186 201 67 68 201 183 196 181 183 68 196 181 184
//  183 180 181 66 183 181 49 195 48 181 66 183 67 180 181 184 182 180 44 185 64
//  201 168 85 66 194 167 168 166 168 185 64 65 167 168 85 201 194 183 168 167 168
//  66 183 65 175 44 26 43 175 174 136 191 175 184 180 185 155 175 174 189 133 130
//  179 134 190 174 173 189 187 193 60 156 184 150 183 194 147 150 151 152 152 130
//  153 154 147 161 176 152 172 129 52 134 194 168 183 185 196 132 184 195 181 184
//  182 195 193 83 185 63 194 185 155 166 186 158 164 167 194 166 168 185 168 201
//  183 66 168 201 167 183 201 183 66 67 68 181 183 67 201 164 88 87 168 83 185 166
//  177 56 154 57 177 130 179 178 130 178 189 179 187 59 39 58 178 154 58 57 200
//  166 100 165 141 200 99 165 187 156 60 148 81 80 193 200 144 166 200 165 141 144
//  200 165 141 142 144 165 141 97 145 143 199 158 105 88 186 158 199 88 85 201 86
//  167 169 22 10 9 199 91 151 198 108 160 107 91 160 107 91 199 199 159 107 106
//  158 164 105 88 186 164 158 88 160 159 107 199 200 99 81 80 188 63 44 43 135 34
//  133 139 33 135 34 133 135 32 133 33 133 137 31 135 133 32 132 51 133 139 34 134
//  174 184 132 195 133 179 139 134 135 138 16 140 138 137 15 191 138 140 6 16 138
//  13 191 14 138 6 140 1 138 191 15 14 188 44 185 175 140 6 7 1 62 63 193 188 187
//  155 189 188 43 189 175 188 176 76 149 152 141 97 143 112 187 130 178 189 188
//  189 41 42 155 185 193 166 192 118 162 117 158 159 199 105 169 23 11 10 159 158
//  199 160 159 157 121 127 150 152 153 151 174 133 130 179 179 134 36 20 177 179
//  36 37 177 153 154 56 196 132 131 184 139 179 20 134 174 137 195 132 144 158 167
//  163 171 172 74 153 191 29 14 28 199 160 151 91 171 151 172 153 182 175 184 180
//  180 181 47 66 168 185 83 64 166 100 82 200 163 168 85 167 174 175 184 182 174
//  184 195 182 180 185 44 175 147 148 156 154 188 185 44 63 177 134 54 36 172 134
//  53 54 177 179 130 134 177 179 134 36 191 175 173 136 170 11 4 3 155 166 193 156
//  151 152 75 161 149 148 154 58 130 174 184 132 166 200 82 193 187 193 61 60 187
//  59 148 60 189 179 39 190 187 154 155 156 177 130 154 153 12 170 138 136 195 182
//  47 29 181 48 195 47 167 186 150 183 185 65 183 180 163 165 197 101 192 157 128
//  123 163 162 164 103 194 155 185 184 165 166 100 101 164 167 163 86 163 197 162
//  103 152 153 55 56 176 94 161 95 163 101 197 102 192 159 127 157 142 161 157 143
//  141 142 165 146 142 159 192 157 192 123 146 157 160 159 157 121 161 143 95 111
//  161 93 151 109 160 161 151 109 118 159 105 119 192 162 197 117 138 15 6 5 160
//  151 161 142 176 145 96 143 176 161 143 95 161 157 110 121 194 166 144 167 72
//  172 92 198 186 89 199 90 172 153 54 74 130 174 179 189 198 91 71 90 146 112 143
//  111 199 158 151 160 163 86 103 164 63 193 188 185 194 144 166 156 79 156 60 80
//  145 200 79 98 149 145 78 77 145 148 78 79 197 162 103 117 39 187 189 40 170 9
//  10 3 192 114 146 124 193 166 185 83 148 187 154 58 193 82 62 81 141 112 146 113
//  181 195 182 47 191 28 182 29 141 113 146 114 151 198 91 92 192 127 159 126 193
//  60 80 61 154 130 178 187 149 58 77 78 148 60 59 79 190 41 189 42 169 179 21 20
//  190 173 42 189 139 35 134 20 139 134 35 34 139 8 140 19 140 7 2 1 135 136 133
//  137 196 132 195 49 174 195 137 182 138 5 1 4 170 1 2 3 169 21 22 9 192 157 127
//  128 179 39 22 38 132 133 129 130 140 7 18 19 135 33 17 32 157 122 111 110 146
//  124 113 123 192 125 116 115 192 126 117 125 159 119 127 120 159 127 119 126 192
//  117 126 118 137 29 191 182 192 125 128 126 197 115 116 101 159 118 126 119 159
//  127 121 120 146 111 123 112 157 123 111 122 192 115 124 125 201 167 183 186 192
//  126 128 127 173 11 25 12 197 117 103 116 160 108 120 121 170 3 4 1 161 121 110
//  109 52 172 53 72 159 106 119 107 157 127 128 122 172 151 92 198 160 107 120 108
//  139 136 179 133 11 24 169 136 162 118 159 105 162 118 105 104 148 79 156 60 137
//  182 195 29 157 122 110 121 129 130 172 131 159 199 105 106 199 107 90 106 146
//  113 124 114 129 196 70 50 186 198 131 70 146 123 113 112 170 9 3 2 165 114 100
//  99 192 116 125 117 143 96 111 112 129 70 198 71 187 59 60 40 161 111 95 110 179
//  21 37 38 145 97 79 78 145 77 96 78 192 124 115 114 157 122 121 127 145 98 79 97
//  192 123 128 124 160 92 91 108 160 92 108 109 109 94 161 93 199 106 90 89 160
//  121 109 108 197 116 103 102 188 175 43 44 129 134 133 52 165 115 101 100 162
//  104 103 117 101 166 100 83 199 106 89 105 159 107 119 120 164 105 87 104 164 88
//  87 105 145 78 96 97 162 104 117 118 190 42 25 41 169 139 136 179 195 31 132 137
//  86 167 163 85 141 113 114 99 196 49 69 50 165 114 115 100 193 83 63 82 141 97
//  113 98 132 137 31 133 173 174 175 189 129 72 52 71 144 158 142 151 144 156 200
//  166 164 104 87 86 192 124 146 123 141 112 113 97 139 140 169 136 192 146 114
//  165 200 100 82 99 176 96 77 95 147 144 161 151 148 78 59 58 176 95 76 94 192
//  197 165 115 151 109 93 92 174 137 191 182 171 93 74 73 163 102 84 101 198 71 91
//  72 183 68 201 196 196 186 70 69 163 197 103 102 140 169 136 170 136 11 173 12
//  68 186 69 88 169 179 22 21 198 90 71 70 73 72 172 92 23 179 22 169 195 48 30 47
//  150 172 198 151 186 90 70 89 25 190 173 42 169 9 170 8 170 140 8 2 163 101 84
//  83 172 73 53 72 199 88 105 89 143 111 96 95 200 82 193 81 66 201 86 85 201 86
//  67 66 188 42 43 189 157 122 128 123 174 133 137 132 168 84 64 83 136 12 173 191
//  93 75 151 171 176 75 94 76 153 172 130 150 166 82 100 83 142 162 192 159 161
//  110 95 94 99 200 81 82 169 190 24 23 197 116 102 101 143 96 112 97 12 191 26
//  173 148 79 59 78 200 79 98 80 196 131 183 184 26 43 25 173 163 84 102 85 138
//  170 4 1 187 41 189 40 193 81 61 80 191 27 175 28 26 191 175 173 176 95 77 76 37
//  56 36 177 191 12 138 136 56 36 177 55 4 12 170 138 171 93 73 92 54 73 172 74
//  171 92 151 93 190 169 136 179 152 154 56 149 153 152 154 56 140 8 2 19 75 151
//  171 152 129 50 70 51 196 70 50 69 171 93 75 74 171 152 151 153 75 93 151 161
//  191 28 14 27 93 94 161 75 164 104 86 103 192 128 125 124 150 172 151 153 171 75
//  152 55 201 87 67 86 201 87 88 68 161 111 157 143 176 149 77 145 79 156 200 145
//  159 106 105 119 161 110 157 111 199 107 91 90 163 144 158 162 142 158 162 159
//  129 71 52 51 168 84 85 65 186 89 69 88 72 129 52 172 145 143 176 147 147 145
//  156 148 175 180 45 44 179 38 22 21 196 68 69 49 181 67 68 48 138 4 13 5 180 66
//  46 65 155 184 175 185 152 56 55 75 133 33 52 34 193 82 63 62 193 61 81 62 200
//  99 165 100 186 89 70 69 155 188 175 189 54 36 74 177 175 28 182 191 182 175 180
//  45 31 133 32 132 45 28 182 175 137 30 195 31 140 17 7 6 57 177 37 178 129 131
//  172 198 129 71 198 72 158 159 105 162 187 39 59 40 176 77 149 76 178 57 58 38
//  186 201 167 164 177 74 153 55 149 56 152 76 178 38 58 39 149 57 76 77 187 154
//  58 178 179 178 38 37 160 159 120 107 160 109 151 92 160 161 109 121 163 103 85
//  102 183 167 194 150 150 158 144 151 53 54 73 172 151 158 142 160 182 47 29 46
//  135 31 17 16 155 188 185 175 180 65 46 45 134 35 54 20 134 34 53 35 185 64 44
//  63 168 65 85 66 180 46 66 47 133 51 33 32 160 159 121 120 160 161 121 157 142
//  157 160 159 139 20 8 35 138 15 137 16 180 64 45 44 129 133 51 52 132 31 50 32
//  134 54 35 53 36 74 177 55 141 200 145 98 138 14 5 13 134 172 53 52 169 8 21 9
//  190 40 23 39 130 134 172 153 160 151 91 92 198 92 72 91 173 12 25 26 181 47 67
//  48 187 193 188 61 195 49 31 48 187 58 148 59 147 154 149 148 195 29 47 30 39
//  179 22 23 137 29 30 15 182 29 28 46 180 65 45 64 170 11 3 10 129 70 196 131 37
//  178 38 57 175 44 27 26 168 84 65 64 132 50 31 49 195 30 48 31 199 198 90 91 136
//  24 169 190 188 62 43 42 43 175 173 26 193 62 188 61 149 77 58 57 135 33 34 18
//  179 37 20 36 182 45 46 28 173 43 25 42 189 42 43 173 163 165 144 197 181 48 68
//  49 190 41 25 24 136 191 174 137 56 57 177 37 190 173 136 24 27 26 191 175 188
//  61 62 42 190 23 40 24 141 113 99 98 23 169 11 24 152 56 75 76 190 41 24 40 169
//  20 139 179 169 8 139 20 169 140 139 8 135 139 136 140 187 41 60 61 134 34 52 53
//  147 145 144 156 179 20 37 21 139 19 140 18 171 55 74 75 135 140 17 18 135 139
//  18 34 137 15 191 29 138 170 1 140 170 140 2 1 169 170 10 11 136 138 140 170 139
//  19 35 8 135 32 17 31 169 10 22 23 134 20 54 36 169 20 21 8 135 33 18 17 132 51
//  32 50 140 18 7 17 129 131 198 70 138 1 5 6 181 67 47 66 169 10 170 9 80 79 156
//  200 170 2 8 9 139 34 35 19 137 31 16 30 138 16 6 15 137 30 16 15 188 42 41 61
//  172 54 153 134 138 5 14 15 142 192 146 157 191 13 27 14 170 12 4 11 191 14 29
//  15 147 151 161 152 191 26 27 13 180 47 182 46 186 201 164 88 137 29 195 30 196
//  181 195 184 165 197 101 115 201 87 68 67 141 165 99 114 141 145 144 143 173 189
//  175 43 142 192 162 197 192 165 114 115 185 63 83 64 138 4 12 13 13 12 191 26
//  154 148 156 187 164 104 162 105 146 157 123 111 201 86 164 87 173 25 11 24 201
//  164 86 167 163 164 158 167 192 117 197 116 175 45 27 44 158 164 162 105 129 71
//  51 70 164 103 162 104 133 52 33 51 141 114 146 165 142 143 144 161 146 157 111
//  143 182 174 175 191 141 200 98 99 140 16 17 6 140 19 2 7 139 18 34 19 188 63 43
//  62 184 155 130 194 141 144 145 200 142 197 144 165

#include <iostream>
#include <string>
#include <fstream>

using namespace std;

int main(int argc, char ** argv) {

    // open the noboite.txt file
    string filename(argv[1]);
    ifstream nobox(filename.c_str());

    // save the result in the pml file
    unsigned int pLast = filename.rfind(".");
    if (pLast != string::npos) {
        filename.erase(pLast);
        filename += "-out.pml";
    }
    else
        filename += "-out.pml";
    ofstream outputFile(filename.c_str());
    outputFile << "<!-- Created by npbox2pml (c) E Promayon, TIMC (c) 1997-2005 -->" << endl;
    outputFile << "<physicalModel name=\"from ghs3d\" >" << endl;

    // vertices
    unsigned int nVertices;
    nobox >> nVertices;

    outputFile << "<atoms>" << endl;
    outputFile << "<structuralComponent name=\"vertices\">" << endl;

    double x, y, z;
    for (unsigned int i=1; i<=nVertices; i++) {
        // read position
        nobox >> x;
        nobox >> y;
        nobox >> z;
        // write atom
        outputFile << "<atom>" << endl;
        outputFile << "<atomProperties index=\"" << i << "\" x=\"" << x << "\"  y=\"" << y << "\" z=\"" << z << "\"  />" << endl;
        outputFile << "</atom>" << endl;
    }

    outputFile << "</structuralComponent>" << endl;
    outputFile << "</atoms>" << endl;

    // regions
    outputFile << "<exclusiveComponents>" << endl;
    outputFile << "<multiComponent name=\"Exclusive Components\">" << endl;
    outputFile << "<structuralComponent name=\"Regions\" mass=\"1\" viscosityW=\"1\" >" << endl;
    outputFile << "<cell>" << endl;
    outputFile << "<cellProperties name=\"cell\" mode=\"NONE\" type=\"POLY_VERTEX\" materialType=\"elastic\" shapeW=\"300\" masterRegion=\"1\" incompressibility=\"0\" />" << endl;
    outputFile << "<color r=\"0.8\" g=\"0.8\" b=\"0.2\" a=\"1.0\" />" << endl;
    for (unsigned int i=1; i<=nVertices; i++)
        outputFile << "<atomRef index=\"" << i <<  "\"/>" << endl;
    outputFile << "</cell>" << endl;
    outputFile << "</structuralComponent>" << endl;

    // tetrahedra => elements (we can then convert the elements to neighborhood using the corresponding physicalmodel lib tool)
    unsigned int nTetra;
    nobox >> nTetra;

    outputFile << "<structuralComponent name=\"Elements\"  mode=\"WIREFRAME_AND_SURFACE\" >" << endl;
    outputFile << "<color r=\".95\" g=\"0.89\" b=\"0.63\" a=\"1.0\"/>" << endl;

    int id;
    for (unsigned int i=0;i<nTetra; i++) {
        outputFile << "<cell>" << endl;
        outputFile << "<cellProperties type=\"TETRAHEDRON\" />" << endl;
        for (unsigned int j=0; j<4; j++) {
            nobox >> id;
            outputFile << "<atomRef index=\"" << id << "\" />" << endl;
        }
        outputFile << "</cell>" << endl;
    }

    outputFile << "</structuralComponent>" << endl;
    outputFile << "</multiComponent>" << endl;
    outputFile << "</exclusiveComponents>" << endl;
    outputFile << "</physicalModel>" <<endl;

    outputFile.close();

}
